;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.equ x, 0
.equ y, 1
.equ width, 2
.equ height, 3
.equ sprite_l, 4
.equ sprite_h, 5
.equ state, 6

.equ last_x, 7
.equ last_y, 8
.equ previousLast_x, 9
.equ previousLast_Y, 10

.equ last_state, 11

.equ front1_l, 12
.equ front1_h, 13

.equ front2_l, 14
.equ front2_h, 15

.equ side1_l, 16
.equ side1_h, 17

.equ side2_l, 18
.equ side2_h, 19

.equ back1_l, 20
.equ back1_h, 21

.equ back2_l, 22
.equ back2_h, 23

.equ s1, 24

.equ left1_l, 25
.equ left1_h, 26
.equ left2_l, 27
.equ left2_h, 28

.equ moving, 29 ;; 0 parado, 1 en movimiento
.equ speed_animation, 30 ;; Comienza siendo 5. Sirve para controlar la velocidad de la animacion

.equ attack, 31
.equ life, 32
.equ cont_attack, 33
.equ last_cont_attack, 34
.equ vivo_muerto, 35
.equ cont_dir, 36
.equ num_animation, 37

.macro defineEntity name, x, y, w, h, sprite, state, last_x, last_y, previousLast_x, previousLast_Y, last_state, animation_front_1, animation_front_2, animation_side_1, animation_side_2, animation_back_1, animation_back_2, s1, animation_left_1, animation_left_2, moving, speed_animation
        name'_data::
        name'_x:: .db x
        name'_y::.db y
        name'_w:: .db w
        name'_h:: .db h
        name'_sprite_ptr:: .dw sprite
        name'_state:: .db state
        name'_last_x:: .db last_x
        name'_last_y:: .db last_y
        name'_previousLast_x:: .db previousLast_x
        name'_previousLast_y:: .db previousLast_Y
        name'_last_state:: .db last_state
        	.dw animation_front_1
        	.dw animation_front_2
        	.dw animation_side_1
        	.dw animation_side_2
        	.dw animation_back_1
        	.dw animation_back_2
            .db s1
            .dw animation_left_1
            .dw animation_left_2
        name'_moving:: .db moving
        name'_speed_animation:: .db speed_animation
        .db #0
        .db #0
        .db #0
        .db #0
        .db #1
        .db #0
        name'_num_animation:: .db #2

.endm

.equ score_or_hp, 11
.macro createObject name, x, y, w, h, sprite, type, last_x, last_y, previousLast_x, previousLast_Y, score_or_hp
    name'_data::
    name'_x:: .db x
    name'_y::.db y
    name'_w:: .db w
    name'_h:: .db h
    name'_sprite_ptr:: .dw sprite
    name'_type:: .db type
    name'_last_x:: .db last_x
    name'_last_y:: .db last_y
    name'_previousLast_x:: .db previousLast_x
    name'_previousLast_y:: .db previousLast_Y
    name'_score_or_hp:: .db score_or_hp
.endm



