;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.area _cuidaooo(ABS)
.org #0x8001
    
;;;
.include "cpctelera.h.s"
.include "utils.h.s"
.include "gameController.h.s"
.include "sprites/sprites.h.s"
.include "dobleBuffer.h.s"
.include "levels/tilemaps.h.s"
.include "tilesets/tilesets.h.s"
.include "dobleBuffer.h.s"
.include "actors/character.h.s"

.globl _g_song_menu

flecha_espera:: .db #0
option: .db #0
play: 			.asciz "Play"
controls: 		.asciz "Controls"
credits: 		.asciz "Credits"
consejo: 		.asciz "Use W/S/Space"
consejo2: 		.asciz "to select an option"
consejo3: 		.asciz "Use Z to go back"
consejo4:		.asciz "Use Z to continue"

controles_1: 	.asciz " to move"
controles: 		.asciz "WASD"
controles2: 	.asciz "SPACE"
controles2_1: 	.asciz " to shoot"
controles4: 	.asciz "P"
controles4_1: 	.asciz " to pause"

credits0: 		.asciz "A GAME OF"
credits1: 		.asciz "Natalia Bernal"
credits2: 		.asciz "Alvaro Esteve"
credits3: 		.asciz "Placido Lopez"
credits4: 		.asciz "PETAFLOPIS TEAM"

historia1:		.asciz " The King entrust "	;;18 CARACTERES CADA LINEA!!!!!!!!!!!!
historia2:		.asciz "you the mission to"
historia3:		.asciz "expel the DarkLord"
historia4:		.asciz "out of the realm. "
historia5:		.asciz "  You'll have to  "
historia6:		.asciz " delve into their "
historia7:		.asciz "fortress and face "
historia8:		.asciz " many dangers that"
historia9:		.asciz "   await  there   "
historia10:		.asciz " TO THE ADVENTURE "

hzmusic_menu: .db #12
only_once: .db #1
.globl isr
menu_loop::

	ld hl, #_g_menu_tileset
	call cpct_etm_setTileset2x4_asm


	ld hl, #_g_menu
	call descomprimir_tilemap
	call background_paint_menu

  ld a, (only_once)
  cp #0
  jp z, noMusica
  dec a 
  ld (only_once), a
  ld de, #_g_song_menu
  call cpct_akp_musicInit_asm
  ld hl, #isr
  call cpct_setInterruptHandler_asm



	
 noMusica:
	lopo_principal:
		call cpct_waitVSYNC_asm
		call repinta_texto
    call cpct_waitVSYNC_asm
		call erase_arrows
		call print_arrow
    call cpct_waitVSYNC_asm
		call flechita_espera
		ld a, (flecha_espera)
		cp #1
		jp z, lopo_principal
		call check_menu_input

		

		cp #1
		jp nz, espacio_no_pulsado
			ld a, (option)
			cp #0
			jp z, lopo_historia
			cp #1
			jp z, lopo_controles
			cp #2
			jp z, lopo_creditos

		espacio_no_pulsado:
		cp #2
		jp nz, w_no_pulsado
			ld a, (option)
			cp #0
			jp z, lopo_principal
			cp #1
			jp nz, no_one
				ld a, #0
				ld (option), a
				jp lopo_principal
			no_one:
				ld a, #1
				ld (option), a
				jp lopo_principal



		w_no_pulsado:
		cp #3
		jp nz, s_no_pulsado
			ld a, (option)
			cp #2
			jp z, lopo_principal
			cp #1
			jp nz, no_two
				ld a, #2
				ld (option), a
				jp lopo_principal

			no_two:
				ld a, #1
				ld (option), a
				jp lopo_principal



		s_no_pulsado:


		jp lopo_principal



	jp lopo_principal
	ret

lopo_controles:

	call cpct_waitVSYNC_asm
	call borra_parte_inferior
	call cpct_waitVSYNC_asm
	call borra_parte_central
	call cpct_waitVSYNC_asm
	call pinta_controles
	ld a, #0
	lopo_controles_input::
    call cpct_waitVSYNC_asm
		call input_controles_creditos 
		cp #1
		jp z, menu_loop
		jp lopo_controles_input


lopo_creditos:
	call cpct_waitVSYNC_asm
	call borra_parte_inferior
	call cpct_waitVSYNC_asm
	call borra_parte_central
	call cpct_waitVSYNC_asm
	call pinta_creditos
	ld a, #0
	lopo_creditos_input:
    call cpct_waitVSYNC_asm
		call input_controles_creditos 
		cp #1
		jp z, menu_loop
		jp lopo_creditos_input

lopo_historia:
	call cpct_waitVSYNC_asm
	call borra_parte_inferior
	call cpct_waitVSYNC_asm
	call borra_parte_central
	call cpct_waitVSYNC_asm
	call borra_parte_superior
	call cpct_waitVSYNC_asm
	call pinta_historia
	ld a, #0
	lopo_historia_input:
		call input_controles_creditos 
		cp #1
		ret z 
		jp lopo_historia_input


pinta_historia:
	  ld hl, #0xC000
  ex de, hl
  ld c, #6
  ld b, #182
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #consejo4          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

  ;;------------------------------------
  ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #13
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia1         ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

   ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #28
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia2         ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

    ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #43
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia3         ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

    ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #58
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia4        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

      ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #73
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia5        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

        ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #88
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia6        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

        ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #103
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia7        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

       ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #118
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia8        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

       ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #133
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia9        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

  ld hl, #0xC000
  ex de, hl
  ld c, #4
  ld b, #148
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #historia10        ;; HL = Pointer to the start of the string
  ld   bc, #0x090D          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm




  ret

pinta_controles:
  ld hl, #0xC000
  ex de, hl
  ld c, #8
  ld b, #182
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #consejo3          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

    ld hl, #0xC000
  ex de, hl
  ld c, #13
  ld b, #93
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #controles          ;; HL = Pointer to the start of the string
  ld   bc, #0x090D         ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

 	  ld hl, #0xC000
 	ex de, hl
 	ld c, #34
 	ld b, #93
 	call cpct_getScreenPtr_asm 
 	ex de, hl
 	ld   hl, #controles_1         ;; HL = Pointer to the start of the string
 	ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
 	call cpct_drawStringM0_asm

 	  ld hl, #0xC000
 	ex de, hl
 	ld c, #13
 	ld b, #106
 	call cpct_getScreenPtr_asm 
 	ex de, hl
 	ld   hl, #controles2         ;; HL = Pointer to the start of the string
 	ld   bc, #0x090D          ;; B = Background colour, C = Foreground colour
 	call cpct_drawStringM0_asm

 	  ld hl, #0xC000
 	ex de, hl
 	ld c, #34
 	ld b, #106
 	call cpct_getScreenPtr_asm 
 	ex de, hl
 	ld   hl, #controles2_1          ;; HL = Pointer to the start of the string
 	ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
 	call cpct_drawStringM0_asm

 	  ld hl, #0xC000
 	ex de, hl
 	ld c, #13
 	ld b, #119
 	call cpct_getScreenPtr_asm 
 	ex de, hl
 	ld   hl, #controles4          ;; HL = Pointer to the start of the string
 	ld   bc, #0x090D          ;; B = Background colour, C = Foreground colour
 	call cpct_drawStringM0_asm	
 	  ld hl, #0xC000
 	ex de, hl
 	ld c, #34
 	ld b, #119
 	call cpct_getScreenPtr_asm 
 	ex de, hl
 	ld   hl, #controles4_1         ;; HL = Pointer to the start of the string
 	ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
 	call cpct_drawStringM0_asm



	ret

pinta_creditos:
	  ld hl, #0xC000
  ex de, hl
  ld c, #8
  ld b, #182
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #consejo3          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm


  ld hl, #0xC000
  ex de, hl
  ld c, #22
  ld b, #83
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #credits0          ;; HL = Pointer to the start of the string
  ld   bc, #0x090D         ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

    ld hl, #0xC000
  ex de, hl
  ld c, #12
  ld b, #100
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #credits1          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F         ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

    ld hl, #0xC000
  ex de, hl
  ld c, #13
  ld b, #120
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #credits2          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F         ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

    ld hl, #0xC000
  ex de, hl
  ld c, #13
  ld b, #140
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #credits3          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F         ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

	
	ret 

input_controles_creditos:
	call check_menu_input
	cp #4
	ld a, #1
	ret z
	ld a, #0
	ret 


borra_parte_inferior:
  ld a, #0xC3
  push af
  ld hl, #0xC000
  ex de, hl
  ld c, #0
  ld b, #180
  call cpct_getScreenPtr_asm 
  ex de, hl
  pop af
  ld c, #64
  ld b, #20
  call cpct_drawSolidBox_asm 


  ld a, #0xC3
  push af
  ld hl, #0xC000
  ex de, hl
  ld c, #64
  ld b, #180
  call cpct_getScreenPtr_asm 
  ex de, hl
  pop af
  ld c, #64
  ld b, #20
  call cpct_drawSolidBox_asm
  ret 

 borra_parte_central:
	  ld a, #0xC3
	  push af
	  ld hl, #0xC000
	  ex de, hl
	  ld c, #4
	  ld b, #92
	  call cpct_getScreenPtr_asm 
	  ex de, hl
	  pop af
	  ld c, #50
	  ld b, #44
	  call cpct_drawSolidBox_asm 


	  ld a, #0xC3
	  push af
	  ld hl, #0xC000
	  ex de, hl
	  ld c, #48
	  ld b, #92
	  call cpct_getScreenPtr_asm 
	  ex de, hl
	  pop af
	  ld c, #28
	  ld b, #44
	  call cpct_drawSolidBox_asm
	  ret 

 borra_parte_superior:
	  ld a, #0xC3
	  push af
	  ld hl, #0xC000
	  ex de, hl
	  ld c, #4
	  ld b, #9
	  call cpct_getScreenPtr_asm 
	  ex de, hl
	  pop af
	  ld c, #50
	  ld b, #55
	  call cpct_drawSolidBox_asm 


	  ld a, #0xC3
	  push af
	  ld hl, #0xC000
	  ex de, hl
	  ld c, #48
	  ld b, #9
	  call cpct_getScreenPtr_asm 
	  ex de, hl
	  pop af
	  ld c, #28
	  ld b, #55
	  call cpct_drawSolidBox_asm
	  ret

background_paint_menu::

  ld hl, #0x0041                  ;;En HL se guarda el puntero al tilemap que se quiera pintar
  push hl
  ld hl, #0xC000
  push hl


  ld b, #0                             ;; Coordenada Y EN TILES de donde empieza el cuadrado en el tilemap
  ld c, #0                             ;; Coordenada X EN TILES de donde empieza el cuadrado en el tilemap
  ld e, #40                            ;; Anchura del cuadrado de tilemap que se quiere pintar 
  ld d, #45                           ;; Altura de cuadrado de tilemap que se quiere pintar
  ld a, #40                            ;; Anchura total del mapa EN TILES
  call  cpct_etm_drawTileBox2x4_asm

  call borra_parte_inferior




  ld hl, #0xC000
  ex de, hl
  ld c, #13
  ld b, #182
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #consejo          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

  ld hl, #0xC000
  ex de, hl
  ld c, #1
  ld b, #191
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #consejo2          ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

  call repinta_texto
  ret 

repinta_texto:

  ld hl, #0xC000
  ex de, hl
  ld c, #26
  ld b, #105
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #play           ;; HL = Pointer to the start of the string
  ld a, (option)
  cp #0
  call z, pinta_amarillo
  call nz, pinta_negro
  
  call cpct_drawStringM0_asm

  ld hl, #0xC000
  ex de, hl
  ld c, #26
  ld b, #115
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #controls           ;; HL = Pointer to the start of the string
  ld a, (option)
  cp #1
  call z, pinta_amarillo
  call nz, pinta_negro          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

  ld hl, #0xC000
  ex de, hl
  ld c, #26
  ld b, #125
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #credits           ;; HL = Pointer to the start of the string
  ld a, (option)
  cp #2
  call z, pinta_amarillo
  call nz, pinta_negro         ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm


  ret


flechita_espera:
	ld a, (flecha_espera)
	xor #1
	ld (flecha_espera), a
	ret

pinta_amarillo:
	ld bc, #0x090D
	ret

pinta_negro:
	ld bc, #0x090F
	ret

print_arrow::
	
    
    ld a, (option)
    ld de ,#0xC000

	cp #0
	jp nz, no_pintar_arriba
		ld c, #21
    	ld b, #100
    	call cpct_getScreenPtr_asm
    	ex de, hl

    	ld c, #4
    	ld b, #16
    	ld hl, #_g_arrow
    	call cpct_drawSpriteMasked_asm 
    	ret 


	no_pintar_arriba:
	cp #1
	jp nz, no_pintar_medio
		ld c, #21
    	ld b, #110
    	call cpct_getScreenPtr_asm
    	ex de, hl

    	ld c, #4
    	ld b, #16
    	ld hl, #_g_arrow
    	call cpct_drawSpriteMasked_asm  
    	ret 



	no_pintar_medio:
		ld c, #21
    	ld b, #120
    	call cpct_getScreenPtr_asm
    	ex de, hl

    	ld c, #4
    	ld b, #16
    	ld hl, #_g_arrow
    	call cpct_drawSpriteMasked_asm 
    	ret

	ret


erase_arrows:
  ld a, #0xC3
  push af
  ld hl, #0xC000
  ex de, hl
  ld c, #21
  ld b, #100
  call cpct_getScreenPtr_asm 
  ex de, hl
  pop af
  ld c, #4
  ld b, #40
  call cpct_drawSolidBox_asm
  ret



 check_menu_input::
    call cpct_scanKeyboard_f_asm

    call cpct_isAnyKeyPressed_f_asm ;;Si no hay ninguna tecla pulsada salimos de la rutina
    cp #0                           ;; A == 0?
    jp z, no_keys                          ;; |

    ld hl, #0x8005
    call cpct_isKeyPressed_asm
    cp #0
    jr z, space_not_pressed_m
        ;;ESPACIO Pulsado
        ld a, #1
        ret



    space_not_pressed_m:
    ld hl, #0x0807
    call cpct_isKeyPressed_asm
    cp #0
    jr z, w_not_pressed_m
        ;;W Pulsada
        ld a, #2
        ret



    w_not_pressed_m:
    ld hl, #0x1007
    call cpct_isKeyPressed_asm
    cp #0
    jr z, s_not_pressed_m
        ;;S Pulsada
        ld a, #3
        ret


    s_not_pressed_m:
    ld hl, #0x8008
    call cpct_isKeyPressed_asm
    cp #0
    jr z, no_keys
        ;;S Pulsada
        ld a, #4
        ret

    no_keys:
        ld a, #0
        ret




_g_arrow:   
    .db 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0x00, 0xf3, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0x00, 0xf3, 0x00, 0xf3, 0xff, 0x00, 0xff, 0x00
    .db  0x00, 0xb7, 0x00, 0x7b, 0x00, 0xf3, 0xff, 0x00
    .db  0x00, 0xb7, 0x00, 0x3f, 0x00, 0x7b, 0x00, 0xf3
    .db  0x00, 0xb7, 0x00, 0x3f, 0x00, 0x7b, 0x00, 0xf3
    .db  0x00, 0xb7, 0x00, 0x7b, 0x00, 0xf3, 0xff, 0x00
    .db  0x00, 0xf3, 0x00, 0xf3, 0xff, 0x00, 0xff, 0x00
    .db  0x00, 0xf3, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
    .db  0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00
  fin_del_menu::
