pub mod blocks;
pub mod config;
pub mod data;
pub mod header;
pub mod tap;
pub mod tzx_data;
pub mod platform;
pub mod player;
pub mod recovery_enum;
pub mod waveforms;

pub use config::Config;
pub use header::Header;
pub use tzx_data::TzxData;
pub use platform::Platform;
pub use player::Player;
pub use recovery_enum::RecoveryEnum;

pub trait ExtendedDisplayCollector {
    fn push(&mut self, piece: &dyn std::fmt::Display);
}
