/*
 * Copyright (c) 1996 The Regents of the University of Michigan
 * All Rights Reserved
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit at the University of Michigan.
 * 
 * Merit GateDaemon Project
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * This copyright has ben automaticly added by the util/addcopyright.pl program.
 * __END_OF_COPYRIGHT__
 */

/*
 * Create callback list of routines to be called when
 * we are asked to resolve a forwarding cache entry.
 */

struct krt_mfc_recv {
    struct krt_mfc_recv *forw, *back;
    int errno;
    void (*recv_routine)();
};

#define	MFC_RECV_SCAN(cur, head) \
		{ for (cur = (head)->forw; cur != head; cur = cur->forw)
#define MFC_RECV_SCAN_END(cur, head) \
		if (cur == head) cur = (struct krt_mfc_recv *) 0; }

extern struct krt_mfc_recv krt_mfc_recv_head;

PROTOTYPE(krt_init_mfc,
	  extern void,
	  (void));

PROTOTYPE(krt_generate_mfc,
	  extern void,
	  (int,
	   sockaddr_un *,
	   if_addr *,
	   sockaddr_un *));

PROTOTYPE(krt_update_mfc,
	  extern void,
	  (mfc *));

PROTOTYPE(krt_check_mfc,
	  extern void,
	  (int,
	   sockaddr_un *,
	   sockaddr_un *));

PROTOTYPE(krt_register_mfc,
	  extern void,
	  (int,
	  _PROTOTYPE(func,
		     void,
		     (int,
		      if_addr *,
		      mfc *))));

PROTOTYPE(krt_unregister_mfc,
	  extern void,
	  (int,
	  _PROTOTYPE(func,
		     void,
		     (int,
		      if_addr *,
		      mfc *))));

PROTOTYPE(krt_resolve_cache,
	  extern void,
	  (sockaddr_un *,
	   sockaddr_un *,
	   mfc *));

PROTOTYPE(krt_flush_cache, 
	extern int,
	(void));

PROTOTYPE(krt_delete_cache,
	  extern int,
	  (sockaddr_un *,
	   sockaddr_un *));

PROTOTYPE(krt_request_cache,
	  extern int,
	  (mfc *,
	   _PROTOTYPE(callback,
		      void,
		      (mfc *))));

PROTOTYPE(krt_enable_cache,
	  extern void,
	  (task *));

PROTOTYPE(krt_disable_cache,
	  extern void,
	  (task *));

PROTOTYPE(krt_locate_upstream,
	  extern upstream *,
	  (sockaddr_un *,
	   int));

/*PROTOTYPE(krt_add_vif,
	  extern void,
	  (if_addr *,
	   u_int32,
	   u_int32));

PROTOTYPE(krt_add_tunnel,
	  extern if_addr *,
	  (if_addr *,
	   sockaddr_un *));

PROTOTYPE(krt_del_vif,
	  extern void,
	  (if_addr *));
*/
