#define	RIPNG_CONFIG_IN			1
#define	RIPNG_CONFIG_OUT		2
#define	RIPNG_CONFIG_METRICIN		3
#define	RIPNG_CONFIG_METRICOUT		4
#define	RIPNG_CONFIG_MAX		5

extern flag_t ripng_flags;
extern trace *ripng_trace_options;
extern metric_t ripng_default_metric;
extern metric_t ripng_preference;
extern int ripng_n_trusted;
extern gw_entry *ripng_gw_list;
extern adv_entry *ripng_export_list;
extern adv_entry *ripng_import_list;
extern adv_entry *ripng_int_policy;

/* Values for ripng_flags */
#define RIPNGF_ON		BIT(0x01)	/* RIPng is enabled */
#define RIPNGF_TERMINATE	BIT(0x02)	/* RIPng is terminating */

#define RIPNG_METRIC_SHUTDOWN		15
#define RIPNG_METRIC_UNREACHABLE	16
#define RIPNG_METRIC_NEXTHOP		255

#define RIPNG_LIMIT_METRIC		1, RIPNG_METRIC_UNREACHABLE /* for parser */

/*  */

PROTOTYPE(ripng_init,
	  extern void,
	  (void));
PROTOTYPE(ripng_var_init,
	  extern void,
	  (void));
