#include "ripng.h"

/* ripng_init.c */
extern sockaddr_un *ripng_addr;

/* ripng_targets.c */
extern target ripng_targets;
extern task_timer *ripng_timer_update;
extern task_timer *ripng_timer_expire;
extern task_timer *ripng_timer_garbage;

/* ripng_send.c */

/* ripng_dump.c */
extern const bits ripng_cmd_bits[];

/*  */

#define RIPNG_PORT	521
#define RIPNG_ADDR	{ htonl(0xff020000), 0, 0, htonl(9) }
#define RIPNG_MAXHOPLIM	255

struct ripng {
    u_int8	ripng_command;
    u_int8	ripng_version;
    u_int16	ripng_null16;
};

#define RIPNG_COMMAND_REQUEST		1
#define RIPNG_COMMAND_RESPONSE		2
#define RIPNG_COMMAND_MAX			3

#define RIPNG_VERSION_1			1

struct ripng_netinfo {
    struct in6_addr	ripng_prefix;
    u_int16		ripng_tag;
    u_int8		ripng_prefixlen;
    u_int8		ripng_metric;
};

struct ripng_nexthop {
    struct in6_addr	ripng_nexthop;
    u_int16		ripng_null16;
    u_int8		ripng_null8;
    u_int8		ripng_fill8;
};
    

#define RIPNG_T_UPDATE		(14 + (grand(1000000) % 31)) /* 30+-15sec */
#define RIPNG_T_EXPIRE		180
#define RIPNG_T_GARBAGE_COLLECT	120

#define RIPNGTF_MC	TARGETF_USER1	/* use multicast */
#define RIPNGTF_POLL	TARGETF_USER2	/* already polled */

/*  */
/* ripng_dump.c */
PROTOTYPE(ripng_dump,
	  extern void,
	  (task *, FILE *));
PROTOTYPE(ripng_trace,
	  extern void,
	  (trace *,
	   int,
	   if_addr *,
	   sockaddr_un *,
	   register struct ripng *,
	   register size_t,
	   int));
PROTOTYPE(ripng_tsi_dump,
	  extern void,
	  (FILE *,
	   rt_head *,
	   void_t,
	   const char *));

/* ripng_targets.c */
PROTOTYPE(ripng_ifachange,
	  extern void,
	  (task *,
	   if_addr *));
PROTOTYPE(ripng_flash,
	  extern void,
	  (task *,
	   rt_list *));
PROTOTYPE(ripng_expire,
          extern void,
          (task_timer *,
           time_t));

/* ripng_send.c */
PROTOTYPE(ripng_job,
	  extern void,
	  (task_timer *,
	   time_t));
PROTOTYPE(ripng_supply,
	  extern void,
	  (task *,
           target *,
	   sockaddr_un *,
	   flag_t,
	   flag_t,
	   int));
PROTOTYPE(ripng_send,
	  extern void,
	  (task *,
	   if_addr *,
	   flag_t,
	   sockaddr_un *,
	   struct ripng *,
	   size_t));

/* ripng_recv.c */
PROTOTYPE(ripng_recv,
	  extern void,
	  (task *));
