/* 
 * local group database
 */
  
struct v6_group_list { 
    struct v6_group_list *forw, *back;
    struct in6_addr group_addr;          /* Group address */
    struct in6_addr last_addr;           /* Last host to report group */
    flag_t group_flags;                 /* status info about group */ 
    time_t refresh_time;                /* Time of last refresh */
}; 

/* 
 * tracing declarations
 */
#define TR_ICMPV6_GROUP_INDEX_QUERY     5       /* Query packets */
#define TR_ICMPV6_GROUP_INDEX_REPORT    6       /* New and old Report packets */
#define TR_ICMPV6_GROUP_INDEX_LEAVE     7       /* Leave packets */
#define TR_ICMPV6_GROUP_INDEX_MTRACE    8       /* Cisco & traceroute mcast packets */

#define TR_ICMPV6_GROUP_DETAIL_QUERY    TR_DETAIL_1
#define TR_ICMPV6_GROUP_DETAIL_REPORT   TR_DETAIL_2
#define TR_ICMPV6_GROUP_DETAIL_LEAVE    TR_DETAIL_3 
#define TR_ICMPV6_GROUP_DETAIL_MTRACE   TR_DETAIL_4

/*
 * Declaration used only for ICMPv6 Group management
 */
#define ICMPV6_GROUP_BASE_TYPE		130
#define ICMPV6_GROUP_MAX_TYPE		132
#define ICMPV6_GROUP_MIN_PACKET_LENGTH	24  	/* 24 octets */

#define ICMPV6_MAX_HOST_REPORT_DELAY	10

/*
 * Used to scan the local group database
 */

#define GROUP_LIST(gp, list)	{ for (gp = (list)->forw; gp != list; gp = gp->forw)
#define GROUP_LIST_END(gp, list)        if (gp == list) gp = (struct v6_group_list *) 0; }


/*
 * Group Change defines
 */
#define ICMPV6_GROUP_ADDED	1
#define ICMPV6_GROUP_REMOVED	2

#define ICMPV6_GROUP_CONFIG_ENABLE	1
#define ICMPV6_GROUP_CONFIG_DISABLE	2
#define ICMPV6_GROUP_CONFIG_MAX		3

#define IFPS_DR_STATUS			IFPS_KEEP1

#define icmpv6_group_if_group_list	ifa_ps[RTPROTO_ICMPV6].ips_datas[0]
#define icmpv6_group_if_timer_timeout   ifa_ps[RTPROTO_ICMPV6].ips_datas[1]
#define icmpv6_group_if_proto           ifa_ps[RTPROTO_ICMPV6].ips_datas[2]

/* Global variable */
extern struct in6_addr icmpv6_ll_allnodes;
extern struct in6_addr icmpv6_ll_allrouters;

/* Prototype of routines */
PROTOTYPE(icmpv6_group_dump,
		static void,
		(task *,
		FILE *));
