
/* $Id: brform.cc,v 1.8 1997/06/27 15:06:14 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#include "dbbrowse.h"
#include "brform.h"
#include <iostream.h>
#include "qform.h"
#include "postgr.h"
#include <math.h>
#include "tform.h"

//////////////////////////////////////////////////////////
//           X11 INTERFACE - browser window             //
//////////////////////////////////////////////////////////

BrowserForm *browser_form;

//
//////////////// Callback routines ////////////////
//

void BrowseButtonCallback(FL_OBJECT *,long){
  browser_form->browse_button_callback();
}

///////////////////////////////////////////////////         
void DisplayButtonCallback(FL_OBJECT *,long){
  browser_form->display_button_callback();
}

///////////////////////////////////////////////////         
void SearchButtonCallback(FL_OBJECT *,long){
  browser_form->search_button_callback();
}
///////////////////////////////////////////////////         
void QueryButtonCallback(FL_OBJECT *,long){
  browser_form->query_button_callback();
}

///////////////////////////////////////////////////         

void FieldSliderCallback(FL_OBJECT *slider,long){
  browser_form->field_slider_callback(slider);
}  

///////////////////////////////////////////////////         

void FieldCallback(FL_OBJECT *input,long no){
  browser_form->field_callback(input,no);
}

///////////////////////////////////////////////////         

void FieldButtonCallback(FL_OBJECT *,long d){
  browser_form->field_button_callback(d);
}

///////////////////////////////////////////////////         

void RecordButtonCallback(FL_OBJECT *,long d){
  browser_form->record_button_callback(d);
}

///////////////////////////////////////////////////         

void RecordSliderCallback(FL_OBJECT *slider,long){
  browser_form->record_slider_callback(slider);
}

///////////////////////////////////////////////////         

void DeleteButtonCallback(FL_OBJECT *,long){
  browser_form->delete_button_callback();
}

///////////////////////////////////////////////////         

void CopyButtonCallback(FL_OBJECT *,long){
  browser_form->copy_button_callback();
}

///////////////////////////////////////////////////         

void TableChoiceCallback(FL_OBJECT *choice,long){
  browser_form->table_choice_callback(choice);
}

///////////////////////////////////////////////////         

void OrderByChoiceCallback(FL_OBJECT *choice,long no){
  browser_form->order_by_choice_callback(choice,no);
}

///////////////////////////////////////////////////         

void UsingChoiceCallback(FL_OBJECT *choice,long){
  browser_form->using_choice_callback(choice);
}  

///////////////////////////////////////////////////         

void FileMenuCallback(FL_OBJECT *menu,long){
  browser_form->file_menu_callback(menu);
}

///////////////////////////////////////////////////         

int BrowserForm::at_close(FL_FORM *form,void *data){

  delete (BrowserForm *)data;
  exit(0);
}

//
///////////////////////////////////////////////////
//

String BrowserForm::file_menu_text="Quit";

BrowserForm::BrowserForm(DBase *db){

  DEBUG_MSG("Setting up form!\n");
  dbase=db;
  form=create_form_browser();
  setup_table_choice();
  setup_menus();
  set_mode(mode_none);
  fl_set_form_atclose(form->browser,at_close,this);
  fl_show_form(form->browser,FL_PLACE_SIZE,FL_FULLBORDER,"DBBrowser");
}

///////////////////////////////////////////////////

int BrowserForm::go(){
  DEBUG_MSG("Starting form...\n");
  fl_do_forms();
  DEBUG_MSG("Form done!\n");
}

///////////////////////////////////////////////////

BrowserForm::~BrowserForm(){

  TableForm::delete_all();
  fl_hide_form(form->browser);
  fl_free_form(form->browser);
  delete dbase;
}

///////////////////////////////////////////////////

void BrowserForm::set_mode(mode_type m){

  if (mode==m) return;
  if (table==""){
    m=mode_none;
  }
  mode=m;
  if (mode!=mode_search) fl_set_button(form->search_button,0);
  if (mode==mode_browse){
    enable_object(form->delete_button);
    enable_object(form->copy_button);
  }  
  else{
    disable_object(form->delete_button);
    disable_object(form->copy_button);
  }
  if (mode==mode_browse || mode==mode_search){
    enable_object(form->previous_record_button);
    enable_object(form->next_record_button);
    enable_object(form->record_slider);
  }  
  else{  
    disable_object(form->previous_record_button);
    disable_object(form->next_record_button);
    disable_object(form->record_slider);
  }  
  if (mode==mode_none){
    for(int i=0;i<6;i++) 
      fl_deactivate_object(form->field[i]);
    disable_object(form->field_up_button);
    disable_object(form->field_down_button);
    disable_object(form->field_slider);
  }
  else{
    enable_object(form->field_up_button);
    enable_object(form->field_down_button);
    enable_object(form->field_slider);
  }
}

///////////////////////////////////////////////////

void BrowserForm::update(){

  int i=0;
  for(;i<(dbase->no_fields()-field_no<?6);i++){
    if (record_no<dbase->no_tuples())
      fl_set_input(form->field[i],dbase->get_value(i+field_no));
    else
      fl_set_input(form->field[i],"");
  }  
}


///////////////////////////////////////////////////

void BrowserForm::update_sliders(){

  fl_set_slider_bounds(form->field_slider,0,dbase->no_fields()-6);
  fl_set_slider_value(form->field_slider,field_no);
  fl_set_slider_bounds(form->record_slider,0,dbase->no_tuples());
  fl_set_slider_value(form->record_slider,record_no);
}

///////////////////////////////////////////////////

void BrowserForm::update_fields(){

  int i=0;
  int f=field_no;
  for(;i<(dbase->no_fields()-field_no<?6);i++,f++){
    fl_set_object_label(form->field[i],dbase->field_name(f));
    if ((record_no<dbase->no_tuples() && record_no>=0) && mode!=mode_search)
      fl_set_input(form->field[i],dbase->get_value(f));
    else
      fl_set_input(form->field[i],"");
    fl_activate_object(form->field[i]);
  }  
  for(;i<6;i++){
    fl_set_object_label(form->field[i],"");
    fl_set_input(form->field[i],"");
    fl_deactivate_object(form->field[i]);
  }  
}

///////////////////////////////////////////////////

void BrowserForm::full_update(){

  update_sliders();
  update_fields();
}

///////////////////////////////////////////////////

void BrowserForm::prepare_browse(String *o,String *u){

  if (mode==mode_browse){
    if (record_no==dbase->no_tuples()) do_add();
    else do_change();
  }  

  for(int i=0;i<3;i++){
    o[i]=fl_get_choice_text(form->order_by_choice[i]);
    u[i]=fl_get_choice_text(form->using_choice[i]);
    if (o[i]=="(none)") o[i]="";
    for(int j=0;j<i;j++)
      if (o[i]==o[j]){
        o[i]="";
        break;
      }
    if (o[i]==String("") || u[i]=="(default)") u[i]="";
  }  

}  

///////////////////////////////////////////////////

void BrowserForm::browse_button_callback(){

  String o[3],u[3];

  prepare_browse(o,u);

  if (!dbase->get_table(3,o,u)) dbase->query_tuple(0);
    
  set_mode(mode_browse);
  record_no=0;
  field_no=0; 
  full_update();
}
///////////////////////////////////////////////////

int BrowserForm::prepare_search(String *checks){
Regex oper="[~!@#%^&?|$:+-*/<>=]";

  int no_fields=0;
  for(int i=0;i<(dbase->no_fields()<?6);i++){
    String t=fl_get_input(form->field[i]);
    if (t!=""){ 
      no_fields++;
      if (t[0]=='\\'){
        if (t.contains(oper,1))
          checks[i+field_no]=String("= '")+t.after(0)+'\'';
        else
          checks[i+field_no]=t.after(0);
      }    
      else if (t.contains(oper,0)) checks[i+field_no]=t;    
      else checks[i+field_no]=String("= '")+t+'\'';
    }  
  } 
  return no_fields;
}

///////////////////////////////////////////////////

void BrowserForm::search_button_callback(){

  if (mode!=mode_search){
    set_mode(mode_search);
    update_fields();
    return;
  }  

  String o[3],u[3];

  prepare_browse(o,u);

  String * checks=new String [dbase->no_fields()];

  int no_fields=prepare_search(checks);

  if (no_fields){
    if (dbase->search(checks,3,o,u))
       clog<<"searching failed!\n";
    else dbase->query_tuple(0);
  } 
  set_mode(mode_browse);
  record_no=0;
  field_no=0; 
  full_update();
}

///////////////////////////////////////////////////

void BrowserForm::display_button_callback(){
String o[3],u[3],query;

  prepare_browse(o,u);
  query="SELECT * FROM "+table+'\n';
  if (mode==mode_search){
    String * checks=new String [dbase->no_fields()];
    int n=prepare_search(checks);
    if (n>0){
       query+="WHERE\n";
       for(int i=0,n1=0;i<dbase->no_fields();i++)
         if (checks[i]!=""){
           n1++;
           query+=' '+dbase->field_name(i)+' '+checks[i];
           if (n1<n) query+=",\n";
           else query+='\n';
         }  
    }
    delete[] checks;
  }
  if (o[0]!=""||o[1]!=""||o[2]!="") {
    query+="ORDER BY\n ";
    int first=1;
    for(int i=0;i<3;i++){
      if (o[i]=="") continue;
      if (first) first=0;
      else query+=",\n ";
      query+=o[i];
      if (u[i]!="") query+=" USING "+u[i];
    }  
    query+='\n';
  }
  QueryResult *res=new QueryResult(dbase,query);
  if (!res->error()) new TableForm(res);
  else{
    clog<<"Error while querying table!\n";
    delete res;
  }  
}

///////////////////////////////////////////////////

void BrowserForm::query_button_callback(){

  QueryForm * f=new QueryForm(dbase,form->browser);
}

///////////////////////////////////////////////////

void BrowserForm::field_slider_callback(FL_OBJECT *slider){


  int new_no=(int)(floor(fl_get_slider_value(slider)+0.5));
  if (new_no!=field_no){
    if (mode!=mode_search)
      if (record_no==dbase->no_tuples()) do_add();
      else do_change();
    field_no=new_no;
    update_fields();
  }  
}

///////////////////////////////////////////////////

void BrowserForm::field_button_callback(int d){

  if (mode!=mode_search)
    if (record_no==dbase->no_tuples()) do_add();
    else do_change();
  if (field_no+d<=(dbase->no_fields()-6) && field_no+d>=0) field_no+=d;
  update_sliders();
  update_fields();
}

///////////////////////////////////////////////////

void BrowserForm::record_button_callback(int d){

  if (record_no==dbase->no_tuples()) do_add();
  else do_change();
  if (record_no+d<=dbase->no_tuples() && record_no+d>=0){
    record_no+=d;
    dbase->query_tuple(record_no);
    update_sliders();
    update();
  }  
}


///////////////////////////////////////////////////

void BrowserForm::record_slider_callback(FL_OBJECT *slider){

  if (record_no==dbase->no_tuples()) do_add();
  else do_change();
  int new_no=(int)(floor(fl_get_slider_value(slider)+0.5));
  if (new_no!=record_no){ 
    record_no=new_no;
    dbase->query_tuple(record_no);
    update();
  }  
}

///////////////////////////////////////////////////

void BrowserForm::file_menu_callback(FL_OBJECT *menu){
  if (fl_get_menu(menu)==MI_QUIT){
    delete this; 
    exit(0);
  }
}

///////////////////////////////////////////////////

void BrowserForm::table_choice_callback(FL_OBJECT *choice){

  String new_table=fl_get_choice_text(form->table_choice); 
  if (table!=new_table) {
    table=new_table;
    dbase->init_table(table);
    setup_order_by_choices();
    setup_using_choices();
    set_mode(mode_browse);
    record_no=0;
    field_no=0;
    full_update();
  }  
}

///////////////////////////////////////////////////

void BrowserForm::order_by_choice_callback(FL_OBJECT *choice,int no){

  FL_OBJECT *ch;
  ch=form->using_choice[no];
  setup_using_choice(ch,choice);
}

///////////////////////////////////////////////////

void BrowserForm::field_callback(FL_OBJECT *input,int no){

  if (mode==mode_search) return;
  if (record_no==dbase->no_tuples()) do_add();
  else do_change();
}  

///////////////////////////////////////////////////

void BrowserForm::do_add(){

  for(int i=0;i<6 && (i+field_no)<dbase->no_fields();i++)
    if ( String(fl_get_input(form->field[i]))!=""){
      do_add(form->field[i],i);
      break;
    }  
}

///////////////////////////////////////////////////

void BrowserForm::do_add(FL_OBJECT *input,int no){

  String *values=new String[dbase->no_fields()];
  values[no+field_no]=fl_get_input(input);
  int stat=dbase->add(values);
  if (!stat){
    stat=dbase->query_tuple(record_no);
    if (stat){
      delete[] values;
      delete this;
      exit(0);
    }  
  }  
  delete[] values;
  full_update();
}

///////////////////////////////////////////////////

void BrowserForm::do_change(){
  for(int i=0;i<6 && (i+field_no)<dbase->no_fields();i++)
    if (dbase->get_value(i+field_no)!=fl_get_input(form->field[i])){
      do_change(form->field[i],i);
      break;
    }  
}

///////////////////////////////////////////////////

void BrowserForm::do_change(FL_OBJECT *input,int no){

  String val=fl_get_input(input);
  int s=dbase->change(record_no,no+field_no,val); 
  if (!s){
    s=dbase->query_tuple(record_no);
    if (s){
       delete this;
       exit(0);
    }
  }  
  set_mode(mode_browse);
  full_update();
}

///////////////////////////////////////////////////

void BrowserForm::delete_button_callback(){

  if (record_no>=dbase->no_tuples()) return;
  dbase->remove(record_no);
  if (record_no<dbase->no_tuples()){
    int stat=dbase->query_tuple(record_no);
    if (stat){
      delete this;
      exit(0);
    }
  }  
  full_update();
}

///////////////////////////////////////////////////

void BrowserForm::setup_menus(){
  
  fl_set_menu(form->file_menu,file_menu_text); 
}


///////////////////////////////////////////////////

void BrowserForm::setup_table_choice(){

  DEBUG_MSG("Quering for class catalogue...\n");
  int no=dbase->get_table_catalogue();
  if (!no) return;
  for(int i=0;i<no;i++){
    String name=dbase->read_catalogue(i);
    DEBUG_CODE(clog<<"   table: "<<name<<'\n');
    fl_addto_choice(form->table_choice,name);
  }
  dbase->close_catalogue();
  fl_set_choice(form->table_choice,1);
  table_choice_callback(form->table_choice);
}

///////////////////////////////////////////////////

void BrowserForm::setup_order_by_choices(){

  for(int i=0;i<3;i++)  
    setup_order_by_choice(form->order_by_choice[i]);
}  

///////////////////////////////////////////////////

void BrowserForm::setup_order_by_choice(FL_OBJECT *choice){

  fl_clear_choice(choice);
  fl_addto_choice(choice,"(none)");
  for(int i=0;i<dbase->no_fields();i++)
    fl_addto_choice(choice,dbase->field_name(i));
}


///////////////////////////////////////////////////

void BrowserForm::setup_using_choices(){

  for(int i=0;i<3;i++)
    setup_using_choice(form->using_choice[i],form->order_by_choice[i]);
}  

///////////////////////////////////////////////////

void BrowserForm::setup_using_choice(FL_OBJECT *choice,FL_OBJECT *o_choice){

  fl_clear_choice(choice);
  fl_addto_choice(choice,"(default)");

  String field=fl_get_choice_text(o_choice);
  if (field=="" || field=="(none)") return;

  Oid type_id=dbase->field_type(field);

  DEBUG_CODE(clog<<"Field: "<<field<<'\n');

  Oid bool_type=dbase->type_id("bool");
  
  int no=dbase->get_operator_catalogue(bool_type,type_id,type_id);
  if (!no) return;
  for(int i=0;i<no;i++)
    fl_addto_choice(choice,dbase->read_catalogue(i));
  dbase->close_catalogue();  
}

///////////////////////////////////////////////////

void BrowserForm::copy_button_callback(){

  String *values=new String[dbase->no_fields()];
  for(int i=0;i<dbase->no_fields();i++){
    String s=dbase->get_value(i);
    if (i>=field_no && (i-field_no)<6)
      s=fl_get_input(form->field[i-field_no]);
    values[i]=s;  
  }    

  int stat=dbase->add(values);
  if (!stat){
    stat=dbase->query_tuple(record_no);
    if (stat){
      delete[] values;
      delete this;
      exit(0);
    }  
  }  
  delete[] values;
  full_update();
}
