
/* $Id: qform.cc,v 1.3 1997/06/27 00:19:32 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#include "dbbrowse.h"
#include <iostream.h>
#include "qform.h"
#include "postgr.h"
#include "tform.h"

//////////////////////////////////////////////////////////
//     X11 INTERFACE - custom query window              //
//////////////////////////////////////////////////////////

QueryForm *query_form=NULL;

//
//////////////// Callback routines ////////////////
//

void QueryCancelButtonCallback(FL_OBJECT *slider,long){
  query_form->cancel_button_callback();
}

///////////////////////////////////////////////////         

void QuerySendButtonCallback(FL_OBJECT *slider,long){
  query_form->send_button_callback();
}

///////////////////////////////////////////////////         

void QueryClearButtonCallback(FL_OBJECT *slider,long){
  query_form->clear_button_callback();
}

///////////////////////////////////////////////////         

void QueryInputCallback(FL_OBJECT *input,long){
}

///////////////////////////////////////////////////         

int QueryForm::at_close(FL_FORM * form,void * data){

  delete (QueryForm *)data;
  return FL_IGNORE;
}

//
///////////////////////////////////////////////////
//

QueryForm::QueryForm(DBase *db,FL_FORM *par){

  query_form=this;
  parent=par;
  fl_deactivate_form(par);
  DEBUG_MSG("Setting up form!\n");
  dbase=db;
  form=create_form_query();
  fl_set_form_atclose(form->query,at_close,this);
  fl_show_form(form->query,FL_PLACE_SIZE,FL_FULLBORDER,"DBBrowser: Jacek");
}

///////////////////////////////////////////////////         

QueryForm::~QueryForm(){

  QueryResult r(dbase,"ABORT"); // in case a transaction is in progress
  fl_hide_form(form->query);
  fl_free_form(form->query);
  fl_activate_form(parent);
  query_form=NULL;
  delete form;
}

///////////////////////////////////////////////////         

void QueryForm::cancel_button_callback(){

  delete this;
}

///////////////////////////////////////////////////         

void QueryForm::send_button_callback(){

  String query=fl_get_input(form->query_input);
  if (query=="") return;
  QueryResult *res=new QueryResult(dbase,query);
  if (res->error())
    fl_show_alert("Error while sending query",res->error_message(),res->status(),1);
  else if (res->tuples_got()>0){
    new TableForm(res);
    return;
  }  
  else
    fl_show_message("Query succeeded!",res->status(),"");
  delete res;
}

///////////////////////////////////////////////////         

void QueryForm::clear_button_callback(){
  fl_set_input(form->query_input,"");
}

