
/* $Id: qform.h,v 1.3 1997/06/27 00:19:32 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#ifndef QFORM_H 
#define QFORM_H

#include <forms.h>
extern "C"{
#include "form.h"
}

class DBase;

//////////////////////////////////////////////////////////
//    X11 INTERFACE - custom query window               //
//////////////////////////////////////////////////////////

class QueryForm{
  FL_FORM *parent;
  FD_query *form;
  DBase *dbase;
  void disable_object(FL_OBJECT *o){
    fl_deactivate_object(o);
    fl_set_object_lcol(o,FL_INACTIVE_COL);
  }
  void enable_object(FL_OBJECT *o){
    fl_activate_object(o);
    fl_set_object_lcol(o,FL_BLACK);
  }
  static int at_close(FL_FORM *,void *);
public:
  QueryForm(DBase*dbase,FL_FORM *par);
  ~QueryForm();
  void cancel_button_callback();
  void send_button_callback();
  void clear_button_callback();
};
extern QueryForm *query_form;

#endif
