
/* $Id: tform.cc,v 1.6 1997/06/27 00:33:09 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#include "dbbrowse.h"
#include <iostream.h>
#include "tform.h"
#include "postgr.h"
#include "string.h"

//////////////////////////////////////////////////////////
//      X11 INTERFACE - query result window             //
//////////////////////////////////////////////////////////

void TableForm::close_button_callback(FL_OBJECT *,long data){

  delete (TableForm *)(void *)data;
}

///////////////////////////////////////////////////

void TableForm::vert_slider_callback(FL_OBJECT *slider,long data){

  TableForm *ob=(TableForm *)(void *)data;
  int new_val=(int)(fl_get_slider_value(slider)+0.5);
  if (new_val!=ob->first_record){
    ob->first_record=new_val;
    ob->update();
  }  
}

///////////////////////////////////////////////////

void TableForm::button_up_callback(FL_OBJECT *,long data){

  TableForm *ob=(TableForm *)(void *)data;
  if (ob->first_record>0){
    ob->first_record--;
    fl_set_slider_value(ob->vert_slider,ob->first_record);
    ob->update();
  }  

}

///////////////////////////////////////////////////

void TableForm::button_down_callback(FL_OBJECT *,long data){

  TableForm *ob=(TableForm *)(void *)data;
  if ( ob->first_record<ob->frecord_max ){
    ob->first_record++;
    fl_set_slider_value(ob->vert_slider,ob->first_record);
    ob->update();
  }  

}

///////////////////////////////////////////////////

void TableForm::button_left_callback(FL_OBJECT *,long data){

  TableForm *ob=(TableForm *)(void *)data;
  if ( ob->first_field>0 ){
    ob->first_field--;
    fl_set_slider_value(ob->hor_slider,ob->first_field);
    ob->update();
  }  

}

///////////////////////////////////////////////////

void TableForm::button_right_callback(FL_OBJECT *,long data){

  TableForm *ob=(TableForm *)(void *)data;
  if ( ob->first_field<ob->ffield_max ){
    ob->first_field++;
    fl_set_slider_value(ob->hor_slider,ob->first_field);
    ob->update();
  }  

}

///////////////////////////////////////////////////

void TableForm::hor_slider_callback(FL_OBJECT *slider,long data){

  TableForm *ob=(TableForm *)(void *)data;
  int new_val=(int)(fl_get_slider_value(slider)+0.5);
  if (new_val!=ob->first_field){
    ob->first_field=new_val;
    ob->update();
  }  
}

///////////////////////////////////////////////////

int TableForm::at_close(FL_FORM * form,void * data){

  delete (TableForm *)data;
  return FL_IGNORE;
}

//
///////////////////////////////////////////////////
//


TableForm *TableForm::first=NULL;


TableForm::TableForm(QueryResult *qr){

  data=qr;
  next=first;
  if (next) next->previous=this;
  first=this;
  previous=NULL;

  first_field=0;
  first_record=0;
 
  create_form();
  fl_set_form_atclose(form,at_close,this);
  fl_show_form(form,FL_PLACE_SIZE,FL_FULLBORDER,"Query result");
}

///////////////////////////////////////////////////         

TableForm::~TableForm(){

  if (next) next->previous=previous;
  if (previous) previous->next=next;
  else first=next;
  fl_hide_form(form);
  fl_free_form(form);
  delete data;
}

///////////////////////////////////////////////////

void TableForm::delete_all(){

  while(first) delete first;
}

///////////////////////////////////////////////////         

void TableForm::update(){

  for(int i=0;i<no_x_fields;i++)
        fl_set_object_label(labels[i],data->field_name(i+first_field));

  for(int i=0;i<no_y_fields;i++)
    for(int j=0;j<no_x_fields;j++)
        fl_set_object_label(fields[i][j],
                              data->get_value(i+first_record,j+first_field)); 
}

///////////////////////////////////////////////////         

#define FIELD_HEIGHT 20
#define FIELD_WIDTH 100
#define MAX_HEIGHT 400
#define INFO_HEIGHT 120
#define TABLE_HEIGHT (MAX_HEIGHT-INFO_HEIGHT)
#define MAX_WIDTH 600
#define SLIDER_WIDTH 20

void TableForm::create_form(){

  no_x_fields=data->no_fields()<?(MAX_WIDTH/FIELD_WIDTH);
  no_y_fields=data->tuples_got()<?(TABLE_HEIGHT/FIELD_HEIGHT);
  int slid_hor=(no_x_fields<data->no_fields())?1:0;
  int slid_vert=(no_y_fields<data->tuples_got())?1:0;
  int width=no_x_fields*FIELD_WIDTH+SLIDER_WIDTH*slid_vert;
  int height=INFO_HEIGHT+no_y_fields*FIELD_HEIGHT+SLIDER_WIDTH*slid_hor;

  labels=new FL_OBJECT *[no_x_fields];
  fields=new FL_OBJECT **[no_y_fields];
  for(int i=0;i<no_y_fields;i++)
    fields[i]=new FL_OBJECT *[no_x_fields];
  
  form=fl_bgn_form(FL_FLAT_BOX,width,height);
    
    FL_OBJECT *close_button=fl_add_button(FL_NORMAL_BUTTON,(width-80)/2,10,
                                                                80,20,"Close");
    FL_OBJECT *browser=fl_add_browser(FL_NORMAL_BROWSER,10,36,
                           width-20,INFO_HEIGHT-FIELD_HEIGHT-40,""); 

    String str=data->query_cmd();
    char *ptr=new char [str.length()+1];
    memcpy(ptr,(const char *)str,str.length()+1);
    for(;ptr;){
      char * ptr1=strchr(ptr,'\n');
      if (ptr1) *ptr1=0;
      fl_add_browser_line(browser,ptr);
      ptr=ptr1?ptr1+1:0;
    }
    delete ptr;
    
    fl_set_object_callback(close_button,close_button_callback,(long)(void *)this);
    for(int i=0;i<no_x_fields;i++)
      labels[i]=fl_add_box(FL_UP_BOX,i*FIELD_WIDTH,INFO_HEIGHT-FIELD_HEIGHT,
                                 FIELD_WIDTH,FIELD_HEIGHT,data->field_name(i));
    for(int i=0;i<no_y_fields;i++)
      for(int j=0;j<no_x_fields;j++){
        fields[i][j]=fl_add_text(FL_NORMAL_TEXT,
                                j*FIELD_WIDTH,INFO_HEIGHT+i*FIELD_HEIGHT,
                                FIELD_WIDTH,FIELD_HEIGHT,data->get_value(i,j));
        fl_set_object_boxtype(fields[i][j],FL_FRAME_BOX);                        
      }       
    if (slid_hor){  
      hor_slider=fl_add_slider(FL_HOR_SLIDER,SLIDER_WIDTH,height-SLIDER_WIDTH,
                              width-(2+slid_vert)*SLIDER_WIDTH,SLIDER_WIDTH,"");
      ffield_max=data->no_fields()-no_x_fields;                       
      fl_set_slider_bounds(hor_slider,0,ffield_max);
      fl_set_slider_value(hor_slider,0); 
      fl_set_object_callback(hor_slider,hor_slider_callback,(long)(void *)this);
      FL_OBJECT * button_left=fl_add_button(FL_NORMAL_BUTTON,0,
                           height-SLIDER_WIDTH,SLIDER_WIDTH,SLIDER_WIDTH,"@<");
      fl_set_object_callback(button_left,button_left_callback,
                                                            (long)(void *)this);
      FL_OBJECT * button_right=fl_add_button(FL_NORMAL_BUTTON,
                       width-(1+slid_vert)*SLIDER_WIDTH,height-SLIDER_WIDTH,
                                               SLIDER_WIDTH,SLIDER_WIDTH,"@>");
      fl_set_object_callback(button_right,button_right_callback,
                                                            (long)(void *)this);
    }
    if (slid_vert){
      vert_slider=fl_add_slider(FL_VERT_SLIDER,
                             width-SLIDER_WIDTH,INFO_HEIGHT+SLIDER_WIDTH,
                  SLIDER_WIDTH,height-INFO_HEIGHT-(2+slid_hor)*SLIDER_WIDTH,"");
      frecord_max=data->tuples_got()-no_y_fields; 
      fl_set_slider_bounds(vert_slider,0,frecord_max);
      fl_set_slider_value(vert_slider,0); 
      fl_set_object_callback(vert_slider,vert_slider_callback,
                                                         (long)(void *)this);
      FL_OBJECT * button_up=fl_add_button(FL_NORMAL_BUTTON,width-SLIDER_WIDTH,
                           INFO_HEIGHT,SLIDER_WIDTH,SLIDER_WIDTH,"@8>");
      fl_set_object_callback(button_up,button_up_callback,
                                                            (long)(void *)this);
      FL_OBJECT * button_down=fl_add_button(FL_NORMAL_BUTTON,
                       width-SLIDER_WIDTH,height-(1+slid_hor)*SLIDER_WIDTH,
                                               SLIDER_WIDTH,SLIDER_WIDTH,"@2>");
      fl_set_object_callback(button_down,button_down_callback,
                                                            (long)(void *)this);
    }   
  fl_end_form();
}
