
/* $Id: tform.h,v 1.4 1997/06/27 00:19:32 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#ifndef TFORM_H 
#define TFORM_H

#include <forms.h>

class QueryResult;

//////////////////////////////////////////////////////////
//    X11 INTERFACE - Query result window               //
//////////////////////////////////////////////////////////

class TableForm{
  TableForm *next,*previous;
  static TableForm *first;
  FL_FORM *form;
  QueryResult *data;
  FL_OBJECT * hor_slider;
  FL_OBJECT * vert_slider;
  FL_OBJECT ** labels;
  FL_OBJECT *** fields;
  int first_field;
  int first_record;
  int ffield_max;
  int frecord_max;
  int no_x_fields;
  int no_y_fields;

  static int at_close(FL_FORM *,void *);
  static void close_button_callback(FL_OBJECT *,long);
  static void hor_slider_callback(FL_OBJECT *,long);
  static void button_left_callback(FL_OBJECT *,long);
  static void button_right_callback(FL_OBJECT *,long);
  static void vert_slider_callback(FL_OBJECT *,long);
  static void button_up_callback(FL_OBJECT *,long);
  static void button_down_callback(FL_OBJECT *,long);
  void update();
  void create_form();
public:
  TableForm(QueryResult *qr);
  ~TableForm();
  static void delete_all();
};

#endif
