#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <linux/major.h>
#include <scsi/scsi_ioctl.h>

int main(int argc, char *argv[])
{
	int fd;
	struct stat statbuf;

	if (argc != 2) {
		fprintf(stderr, "usage: %s device\n",argv[0]);
		exit(1);
	}
	if ((fd = open(argv[1], O_RDWR)) < 0) {
		perror(argv[1]);
		exit(1);
	}
	if ((fstat(fd, &statbuf)) < 0) {
		perror(argv[1]);
		close(fd);
		exit(1);
	}
	if (!S_ISBLK(statbuf.st_mode)
		|| ((statbuf.st_rdev>>8)&0xff) != SCSI_DISK_MAJOR) {
		fprintf(stderr, "%s is not a SCSI block device\n", argv[1]);
		close(fd);
		exit(1);
	}

	if (ioctl(fd, SCSI_IOCTL_STOP_UNIT) < 0) {
		perror(argv[1]);
		close(fd);
		exit(1);
	}

	close(fd);
	exit(0);
}
